function X = condfsalt(wt)
%X = condfsalt(wt)
% 
% This function will compute the electrical conductance (units mmho/cm = 
% 10^-5 /ohm/m = 10^-5 S/m) from the weight fraction of salt (wt) defined
% as the mass of the salt divided by the total mass of the fluid.  
% Maximum error is <0.6 for wt<0.01 and <0.3 for 0.015<wt<0.16.  Note that
% the temperature of the solution must be at 20 C.  Use tempc20 to remove
% the temperature of the fluid.  The equation is taken from Ruddick and
% Shirtcliffe, 1979.
% 
%USAGE:
%  wt (scalar): Fraction of mass of salt over the mass of the solution (no
%               units)
%
% See also: saltfcond, tempc20, tempc25, wghts, density

if wt < 0 | wt > 0.16
    disp('wt out of range');
    X = 0;
    
else
    a1 = 1581;
    a2 = -3776;
    a3 = 5617;
    
    X = a1*wt + a2*wt^2 + a3*wt^3;
end