function [A,B] = probeAB(V1,T1,V2,T2,Voff)
%[A,B] = probeAB(V1,T1,V2,T2,Voff)
%
% This function will find the constants A and B that are used in
% finding the temperature of a sample using the PME MicroScale
% Conductivity Temperature Probe.  The voltages of V1 and V2 (V)
% are found using calibrated solutions at two different
% temperatures, T1 and T2 (degrees C).  Note that the gain (G) is
% included in A and B.  See the MSCTI manual (www.pme.com) for
% more information.
%
%USAGE:
%  V1 (scalar): Voltage of 1st solution (V)
%  T1 (scalar): Temperature of 1st solution (degrees C)
%  V2 (scalar): Voltage of 2nd solution (V)
%  T2 (scalar): Temperature of 2nd solution (degrees C)
%  Voff (scalar): Off voltage (V) - should be about -5 V
%
%See also: probecond, probeG, probetemp

T1 = T1 + 273.15;
T2 = T2 + 273.15;

B = log((V2-Voff)/(V1-Voff))*T1*T2/(T1-T2);
A = log(V1-Voff)-B/T1;



