function X = probeG(V,Voff,C)
%X = probeG(V,Voff,C)
%
% This function will determine the gain (V m/S) of a the PME
% MicroScale Conductivity Temperature Probe from the measured
% voltage (V), the off voltage (Voff) and a calibration solution
% of known conductivity C (mmho/cm = S/m).  See the MSCTI manual
% (www.pme.com) for more information.
%
%USAGE:
%  V (scalar): Measured voltage (V)
%  Voff (scalar): Off voltage (V) - should be about -5 V.
%  C (scalar): Calibration solution conductivity (S/m)
%
% See also: probeAB, probecond, probetemp, sal2cond

X = (V-Voff)/C;

