function X = probecond(V,Voff,G)
%X = probecond(V,Voff,G)
%
% This function will determine the conductivity (mmho/cm = S/m) of
% a sample using the PME MicroScale Conductivity Temperature Probe
% from the measured voltage (V), the off voltage (Voff) and the
% gain (G, units V m/S).See the MSCTI manual (www.pme.com) for
% more information.
%
%USAGE:
%  V (scalar): Measured voltage (V)
%  Voff (scalar): Off voltage (V) - should be about -5 V.
%  G (scalar): Gain (S/m)
%
% See also: condfsalt, probeAB, probeG, probetemp, saltfcond

X = (V - Voff)/G;

