function X = probetemp(V,Voff,A,B)
%X = probetemp(V,Voff,A,B)
%
% This function will determine the temperature (degrees C) of a
% water sample using the PME MicroScale Conductivity Temperature
% Probe from the measured voltage (V), the off voltage (Voff) and
% calibratedly determined constants A and B.  Note that the gain
% (G) is included in the constants A and B.  See the MSCTI manual
% (www.pme.com) for more information.
%
%USAGE:
%  V (scalar): Measured voltage (V)
%  Voff (scalar): Off voltage (V) - should be about -5 V.
%  A (scalar): Calibratedly determined constant (no units)
%  B (scalar): Calibratedly determined constant (K)
%
% See also: probeAB, probecond, probeG, tempc20, tempc25

X = B/(log(V-Voff)-A) - 273.15;

