function X = saltfcond(lambda)
%X = saltfcond(lambda)
%
% This function will compute the weight fraction of salt (defined as the
% mass of the salt divided by the total mass of the fluid) from the
% conductance, lambda, (in units of mmho/cm = 10^-5 /ohm/m = 10^-5 S/m).
% The maximum limit is lambda < 180 and maximum error is 4x10^-4.  Note
% that the temperature of the solution must be at 20 C.  Use tempc20 to
% remove the temperature of the fluid.  The equation is taken from Ruddick
% and Shirtcliffe, 1979.
% 
%USAGE:
%  lambda (scalar): Electrical conductance of the fluid (mmho/cm)
%
% See also: condfsalt, tempc20, temp25, wghts, density

if lambda < 0 | lambda > 180
    disp('lambda (condcutance) out of range');
    X = 0;
    
else
    a1 = 6.33e-4;
    a2 = 8.92e-7;
    a3 = 3.11e-9;
    
    X = a1*lambda + a2*lambda^2 + a3*lambda^3;
end