function X = tempc25(temp)
%X = tempc25(temp)
% 
%% This function returns the ratio of the electrical conductance (sigma:
% units of mmho/cm = 10^-5 /ohm/m = 10^-5 S/m) of an NaCl - H2O solution
% at temperature 25 degrees C to the electrical conductivity of the
% solution at temperature temp (degrees C).
% 
% tempc25 = sigma(25)/sigma(temp)
%
% Use this function to correct a measured conductivity at T = temp to the
% reference temperature T = 25 for applying the algorithm of Chiu & Fuoss
% (1968).  See also Head 1983 (Thesis).
%
%USAGE:
%  temp (scalar): The temperature of the solution (0 - 100 C)
%
% See also: condfsalt, saltfcond, temp20, wghts, density

if temp < 0 | temp > 100
    disp('Temperature out of range');
    X = 0;
    
else
    a0 = 2.1179818e-2;
    a1 = 7.8601061e-5;
    a2 = 1.5439826e-7;
    a3 = -6.2634979e-9;
    a4 = 2.2794885e-11;
    
    b = a0 + a1*temp + a2*temp^2 + a3*temp^3 + a4*temp^4;
    c = 1/(1+b*(temp-18));
    X = c/0.86053558;
end