function X = wghts(cond,temp)
%X = wghts(cond,temp)
% 
% This function calculates the weight fraction concentration of NaCl - H2O
% solution of electrical conductivity (mmho/cm = 10^-5 /ohm/m = 10^-5 S/m)
% cond at temperature (degrees C) temp.  Limits on cond is 8-89 S/m and
% temp is 0-100 C.  Note that this function calls tempc25.m.  Maximum error
% is +/- 0.6x10^-5.
% See also Head 1983 (Thesis).
%
%USAGE:
%  cond (scalar): The conductivity of the solution (8-89 S/m)
%  temp (scalar): The temperature of the solution (0 - 100 C)
%
% See also: condfsalt, saltfcond, temp20, temp25, density

if temp < 0 | temp > 100
    disp('Temperature out of range');
    X = 0;
    
else
    C = cond*tempc25(temp);
    
    a0 = 0.01498478;
    a1 = -0.01458078;
    a2 = 0.05185288;
    a3 = 0.00206994;
    a4 = -0.00010365;
    a5 = 0.000006269;

    W = a0 + a1*cond^(1/2) + a2*cond + a3*cond^(3/2) + a4*cond^2 + a5*cond^(5/2);
    
    if W < 0.4
        disp('Salinity too low');
        X = 0;
    elseif W > 6.0
        disp('Salinity too high');
        X = 0;
    else
        X = W/100;
    end
end